#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>
#include <bits/stdc++.h>

using namespace __gnu_pbds;
using namespace std;

const long long INF = 1e15;
const int MAXN = 100007;
const long long MOD = 1000000007;
const double PI = acos(-1);

struct Koordinata {
    long long x, y;
    
    Koordinata() {}
    Koordinata(int a, int b) : x(a), y(b) {}
};

Koordinata operator + (Koordinata a, Koordinata b) {
    return Koordinata(a.x + b.x, a.y + b.y);
}

Koordinata operator - (Koordinata a, Koordinata b) {
    return Koordinata(a.x - b.x, a.y - b.y);
}


long long proizvodPreko(Koordinata a, Koordinata b) {
    return a.x * b.y - a.y * b.x;
}

bool jeUkrug(Koordinata a, Koordinata b, Koordinata c) {
    return proizvodPreko(a - b, c - b) >= 0;
}

bool porediUgao(Koordinata a, Koordinata b) {
    return jeUkrug(a, Koordinata(0, 0), b);
}

bool porediPoYx(Koordinata a, Koordinata b) {
    return make_pair(a.y, a.x) < make_pair(b.y, b.x);
}


vector<Koordinata> izracunajKonveksnuOmotnicu(vector<Koordinata> tacke) {
    if (tacke.size() < 3) {
        return tacke;
    }

    sort(tacke.begin(), tacke.end(), porediPoYx);
    Koordinata poreklo = tacke[0];
    
    for (int i = 0; i < tacke.size(); i++) {
        tacke[i] = tacke[i] - poreklo;
    }
    
    sort(tacke.begin() + 1, tacke.end(), porediUgao);
    vector<Koordinata> omotnica;
    
    for (int i = 0; i < tacke.size(); i++) {
        while (omotnica.size() >= 2 && jeUkrug(omotnica[omotnica.size() - 2], omotnica.back(), tacke[i])) {
            omotnica.pop_back();
        }
        omotnica.push_back(tacke[i]);
    }
    
    for (int i = 0; i < omotnica.size(); i++) {
        omotnica[i] = omotnica[i] + poreklo;
    }
    
    return omotnica;
}

long long izracunajPovrsinuPoligona(vector<Koordinata> poligon) {
    if (poligon.size() < 3) {
        return 0;
    }
    long long povrsina = 0;
    long long m = poligon.size();
    
    for (int i = 0; i < m; i++) {
        povrsina += (poligon[i].x * poligon[(i + 1) % m].y - poligon[(i + 1) % m].x * poligon[i].y) / 2;
    }
    
    if (povrsina < 0) {
        povrsina *= -1;
    }
    return povrsina;
}

vector<Koordinata> koordinate, podskupovi[MAXN];

int main() {
    long long brojTacka;
    cin >> brojTacka;
    
    for (int i = 1; i <= brojTacka; i++) {
        long long xKoord, yKoord;
        cin >> xKoord >> yKoord;
        koordinate.push_back(Koordinata(xKoord, yKoord));
    }
    
    vector<Koordinata> omotnica = izracunajKonveksnuOmotnicu(koordinate);
    Koordinata poreklo = omotnica[0];
    
    for (int i = 0; i < koordinate.size(); i++) {
        koordinate[i] = koordinate[i] - poreklo;
    }
    
    for (int i = 0; i < omotnica.size(); i++) {
        omotnica[i] = omotnica[i] - poreklo;
    }
    
    long long velicinaOmotnice = omotnica.size();
    sort(koordinate.begin(), koordinate.end(), porediPoYx);
    sort(koordinate.begin() + 1, koordinate.end(), porediUgao);
    
    long long idx = 2;
    for (int i = 2; i < brojTacka; i++) {
        if (make_pair(koordinate[i].x, koordinate[i].y) == make_pair(omotnica[idx].x, omotnica[idx].y)) {
            idx++;
        } else {
            podskupovi[idx].push_back(koordinate[i]);
        }
    }
    
    vector<Koordinata> temp;
    for (int i = 1; i < brojTacka; i++) {
        temp.push_back(koordinate[i]);
    }
    
    long long najmanjaPovrsina = izracunajPovrsinuPoligona(izracunajKonveksnuOmotnicu(temp));
    long long povrsinaOmotnice = izracunajPovrsinuPoligona(omotnica), povrsinaP1, povrsinaP2;

    temp = podskupovi[2];
    temp.push_back(omotnica[0]);
    temp.push_back(omotnica[2]);
    povrsinaP1 = izracunajPovrsinuPoligona(izracunajKonveksnuOmotnicu(temp));
    
    temp.push_back(omotnica[1]);
    povrsinaP2 = izracunajPovrsinuPoligona(izracunajKonveksnuOmotnicu(temp));
    najmanjaPovrsina = min(najmanjaPovrsina, povrsinaOmotnice - povrsinaP2 + povrsinaP1); 
    temp = podskupovi[velicinaOmotnice - 1];
    temp.push_back(omotnica[0]);
    temp.push_back(omotnica[velicinaOmotnice - 2]);
    povrsinaP1 = izracunajPovrsinuPoligona(izracunajKonveksnuOmotnicu(temp));
    
    temp.push_back(omotnica[velicinaOmotnice - 1]);
    povrsinaP2 = izracunajPovrsinuPoligona(izracunajKonveksnuOmotnicu(temp));
    najmanjaPovrsina = min(najmanjaPovrsina, povrsinaOmotnice - povrsinaP2 + povrsinaP1); 

    for (int i = 2; i < velicinaOmotnice - 1; i++) {
        temp = podskupovi[i];
        for (auto tacka : podskupovi[i + 1]) {
            temp.push_back(tacka);
        }
        temp.push_back(omotnica[i - 1]);
        temp.push_back(omotnica[i + 1]);
        povrsinaP1 = izracunajPovrsinuPoligona(izracunajKonveksnuOmotnicu(temp));
        
        temp.push_back(omotnica[i]);
        povrsinaP2 = izracunajPovrsinuPoligona(izracunajKonveksnuOmotnicu(temp));
        najmanjaPovrsina = min(najmanjaPovrsina, povrsinaOmotnice - povrsinaP2 + povrsinaP1);
    }
    
    cout << najmanjaPovrsina << endl;
    return 0;
}